/*global define, require */
/*jslint white: true */

/*
	randomize path points
*/

define	([	"src/build/Path",	"src/build/CommandPlayer",	"src/math/Vec2",	"src/math/curveUtils",
			"src/math/Random"],
function(	Path,				CommandPlayer,				V2,					curveUtils,
			Random) {
	'use strict';

	var PathPlayer;

	PathPlayer = function (inPath, inMaxPixelDistance, inSeed) {
		var that = this, m_path, m_prints = "", randomizePts, moveCmdIdx, prevPts, prevPrevPts, prevPrevPrevPts, d, r = new Random(inSeed);

		function getPreviousRandomPoint() {
			var	prevPt, cmdIdx, cmds = m_path.getCommands(), prevRandomPts;

			cmdIdx = m_path.getCommands().length-1;
			if (cmdIdx >= 0) {
				prevRandomPts = cmds[cmdIdx].parameters.pts;
				if (prevRandomPts) {
					prevPt = prevRandomPts[prevRandomPts.length-1];
				}
			}
			return prevPt;
		}

		function getPreviousPoint() {
			var	prevPt;

			if (prevPts) {
				prevPt = prevPts[prevPts.length-1].slice(0);
			}
			return prevPt;
		}

		function getPreviousPreviousPoint() {
			var	prevPt;

			if (prevPts) {
				if (prevPts.length-2 > 0) {
					prevPt = prevPts[prevPts.length-2].slice(0);
				} else if (prevPrevPts) {
					prevPt = prevPrevPts[prevPts.length-1].slice(0);
				}
			}
			return prevPt;
		}

		function resetPreviousPoints() {
			prevPrevPrevPts = undefined;
			prevPrevPts = undefined;
			prevPts = undefined;
		}

		function setPreviousPoints(inPts) {
			prevPrevPrevPts = prevPrevPts;
			prevPrevPts = prevPts;
			prevPts = inPts.slice(0);
		}

		randomizePts = function (inPts, inPrevPt) {
			var i, j, pts = [], maxDist, prevPt = inPrevPt;

			for (i = 0; i < inPts.length; i += 1) {
				pts[i] = inPts[i].slice();

				maxDist = inMaxPixelDistance;
				if (prevPt) {
					d = V2.distance(prevPt, pts[i]);
					maxDist = Math.min(d * 0.1, maxDist);
				}
				prevPt = inPts[i];
				for (j = 0; j < 2; j += 1) {
					pts[i][j] += (r.random() - 0.5) * maxDist;
				}
			}
			return pts;
		};

		function reRandomizeFirstPoint(inNextPt) {
			var pts, movePts, cmdIdx, cmds = m_path.getCommands(), prevMovePts;

			cmdIdx = m_path.getCommands().length-1;
			if (moveCmdIdx === cmdIdx) {
				// We now know the next point, so use it so the randomization can use it's distance
				// when attenuating the max pixel amount.
				pts = randomizePts(prevPts, inNextPt);
				cmds[moveCmdIdx].parameters.pts = pts;
				movePts = prevPts;
				resetPreviousPoints();
				setPreviousPoints(movePts);
			}
		}

		that.moveTo = function (inParams) {
			var pts;
			resetPreviousPoints();
			pts = randomizePts(inParams.pts, getPreviousPoint());
			m_path.moveTo(pts[0]);
			moveCmdIdx = m_path.getCommands().length-1;
			setPreviousPoints(inParams.pts);
		};

		that.lineTo = function (inParams) {
			var pts;
			reRandomizeFirstPoint(inParams.pts[0]);
			pts = randomizePts(inParams.pts, getPreviousPoint());
			m_path.lineTo(pts[0]);
			setPreviousPoints(inParams.pts);
		};

		that.bezierToFromPoints = function (inPts, inRandomizedLoopPt) {
			var pts = [], curve, midPt, randPts = [], i, fitCurves, chordLen, tan0 = [],
				tan1 = [], tan2 = [], tan3 = [], midTan = [], tanTdiff = 0.05, d1, d2;

			curve = [getPreviousPoint(), inPts[0], inPts[1], inPts[2]];
			tan0 = curveUtils.evaluate2DCurve(curve, tanTdiff);
			tan3 = curveUtils.evaluate2DCurve(curve, 1 - tanTdiff);
			V2.subtract(tan0, curve[0], tan0);
			V2.subtract(tan3, curve[3], tan3);
			midPt = curveUtils.evaluate2DCurve(curve, 0.5);

			d1 = V2.distance(curve[0], midPt);
			d2 = V2.distance(curve[3], midPt);

			randPts.push(getPreviousPoint().slice());
			randPts.push(midPt);
			randPts.push(inPts[2]);
			pts =  randomizePts(randPts, getPreviousPreviousPoint());

			pts[0] = getPreviousRandomPoint();	// Already randomized.
			if (inRandomizedLoopPt) {
				pts[2] = inRandomizedLoopPt;	// Already randomized.
			}

			V2.normalize(tan0, tan0, d1 / 3);
			V2.add(tan0, pts[0], tan0);
			V2.normalize(tan3, tan3, d2 / 3);
			V2.add(tan3, pts[2], tan3);

			V2.subtract(pts[0], pts[2], midTan);
			V2.normalize(midTan, tan1, d1 / 3);
			V2.add(tan1, pts[1], tan1);
			V2.normalize(midTan, tan2, d2 / 3);
			V2.negate(tan2, tan2);
			V2.add(tan2, pts[1], tan2);
			m_path.bezierTo(tan0, tan1, midPt);
			m_path.bezierTo(tan2, tan3, pts[2]);

			setPreviousPoints(inPts);
		};

		that.bezierTo = function (inParams) {
			reRandomizeFirstPoint(inParams.pts[0]);

			that.bezierToFromPoints(inParams.pts);
		};

		that.close = function () {
			// If the last command was a bezierTo, set the last point to the first point.
			var cmds = m_path.getCommands(), numCmds, tan = [], prevMovePts, curvePts, prevCurvePts, cmdIdx = cmds.length - 1;

			if (cmds.length > 2 && cmds[cmdIdx].cmdName === "bezierTo") {

				// Update the last bezier
				if (cmds.length > moveCmdIdx + 1 && cmds[moveCmdIdx + 1].cmdName === "bezierTo") {
					curvePts = cmds[cmdIdx].parameters.pts;
					prevMovePts = cmds[moveCmdIdx].parameters.pts;

					V2.subtract(curvePts[1], curvePts[2], tan);
					curvePts[2] = prevMovePts[0];
					V2.add(tan, curvePts[2], curvePts[1]);
				}
			}
			m_path.close();
		};

		that.filter = function (inPath) {
			var cmdPlayer = new CommandPlayer(inPath);
			m_path = new Path();
			m_path.setName(inPath.getName());
			cmdPlayer.play(this);
			return m_path;
		};

		return that;
	};

	return function (inPath, inMaxPixelDistance, inSeed) {
		var newPath, player = new PathPlayer(inPath, inMaxPixelDistance, inSeed);
		return player.filter(inPath);
	};
});
